package com.geotab.model.entity.charging;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum ChargeType {
  /**
   * Alternating Current.
   */
  AC("AC"),

  /**
   * Direct Current.
   */
  DC("DC"),

  /**
   * Charge type is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown");
  private final String name;

  ChargeType(String name) {
    this.name = name;
  }

  public static ChargeType findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          ChargeType.class.getSimpleName(), ChargeType.UNKNOWN);
      return UNKNOWN;
    }

    for (ChargeType chargeType : values()) {
      if (chargeType.getName().equalsIgnoreCase(name.trim())) {
        return chargeType;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, ChargeType.class.getSimpleName(), ChargeType.UNKNOWN);
    return UNKNOWN;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
