/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.controller;

import com.geotab.model.Id;
import com.geotab.model.entity.source.SourceBrp;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

/**
 * Controller reserved for faults generated with manufacturer specific codes.
 */
@Data
public final class BrpFaultController extends Controller implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final BrpFaultController INSTANCE = new BrpFaultController();
  }

  public static final String BRP_FAULT_CONTROLLER_ID = "ControllerBrpFaultId";

  private BrpFaultController() {
    setId(new Id(BRP_FAULT_CONTROLLER_ID));
    setName("BRP");
    setVersion(-1L);
    setCode((short) 0);
    setCodeId((short) -1);
    setSource(SourceBrp.getInstance());
  }

  public static BrpFaultController getInstance() {
    return InstanceHolder.INSTANCE;
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
