/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.controller;

import com.geotab.model.Id;
import com.geotab.model.entity.source.SourceLegacy;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

/**
 * Controller reserved for faults generated with legacy manufacturer specific codes.
 */
@Data
public final class LegacyFaultController extends Controller implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final LegacyFaultController INSTANCE = new LegacyFaultController();
  }

  public static final String LEGACY_FAULT_CONTROLLER_ID = "ControllerLegacyFaultId";

  private LegacyFaultController() {
    setId(new Id(LEGACY_FAULT_CONTROLLER_ID));
    setName("Manufacturer Specific");
    setVersion(-1L);
    setCode((short) 0);
    setCodeId((short) -1);
    setSource(SourceLegacy.getInstance());
  }

  public static LegacyFaultController getInstance() {
    return InstanceHolder.INSTANCE;
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
