/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.customproperty;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.geotab.model.entity.EntityWithVersion;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The custom property of an entity that is customizable.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class Property extends EntityWithVersion {

  /**
   * The name of the Property.
   */
  private String name;

  /**
   * The External Reference of the Property.
   */
  private String externalReference;

  /**
   * Indicates whether the Property needs to be populated or not before the entity can be saved.
   */
  @JsonProperty("isRequired")
  private Boolean isRequired;

  /**
   * Indicates whether the Property is visible or not to the UI.
   */
  @JsonProperty("isVisible")
  private Boolean isVisible;

  /**
   * The minimum length of the Property.
   */
  private Integer minLength;

  /**
   * The maximum length of the Property.
   */
  private Integer maxLength;

  /**
   * The support type of the Property.
   */
  private SupportedPropertyType propertyType;

  /**
   * The {@link PropertySet} that this Property belongs to.
   */
  private PropertySet propertySet;
}
