/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.debugdata;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.entity.Entity;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.user.Driver;
import com.geotab.model.serialization.ByteArrayDeserializer;
import com.geotab.model.serialization.ByteArraySerializer;
import com.geotab.model.serialization.DriverEmbeddedSerializer;
import com.geotab.model.serialization.DriverFromIdDeserializer;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * DebugData is generated by Geotab GO devices for internal debugging or troubleshooting purposes. This may include
 * information regarding the state of the modem, firmware or conditions that the device is experiencing.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class DebugData extends Entity {

  /**
   * The binary data.
   */
  @JsonDeserialize(using = ByteArrayDeserializer.class)
  @JsonSerialize(using = ByteArraySerializer.class)
  private Byte[] data;

  /**
   * The Driver of the vehicle at the time the DebugData log entry was created.
   */
  @JsonDeserialize(using = DriverFromIdDeserializer.class)
  @JsonSerialize(using = DriverEmbeddedSerializer.class)
  private Driver driver;

  /**
   * The device associated with the vehicle.
   */
  private Device device;

  /**
   * The date and time the DebugData log was created.
   */
  private LocalDateTime dateTime;

  /**
   * The DebugReason; used for troubleshooting/debugging purposes only.
   */
  private String debugReason;
}
