/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.device;

import static java.lang.Boolean.FALSE;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "a1Builder")
public class A1 extends GoCurveAuxiliary {

  /**
   * Enables or disables OBD alerts for the device. Default [False].
   */
  protected Boolean obdAlertEnabled;

  {
    setDeviceType(DeviceType.A1);
  }

  @Override
  public void populateDefaults() {
    super.populateDefaults();
    this.productId = A1_PRODUCT_ID;
    this.obdAlertEnabled = FALSE;
  }
}
