package com.geotab.model.entity.device;

import lombok.experimental.UtilityClass;

/**
 * Device type names extracted to constants as workaround, to be used in both {@link DeviceType} enum attributes and in
 * {@link com.fasterxml.jackson.annotation.JsonSubTypes.Type} for polymorphic deserialization.
 */
@UtilityClass
public final class DeviceTypeNameConstants {

  public static final String NONE = "None";

  public static final String OLD_GEOTAB = "OldGeotab";

  public static final String GO2 = "GO2";

  public static final String GO3 = "GO3";

  public static final String GO4 = "GO4";

  public static final String GO4V3 = "GO4v3";

  public static final String GO5 = "GO5";

  public static final String GO6 = "GO6";

  public static final String GO7 = "GO7";

  public static final String GO8 = "GO8";

  public static final String GO9 = "GO9";

  public static final String GO9B = "GO9B";

  public static final String GO10 = "GO10";

  public static final String CUSTOM_DEVICE = "CustomDevice";

  public static final String GO_DRIVE_DEVICE = "GoDriveDevice";

  public static final String CUSTOM_VEHICLE_DEVICE = "CustomVehicleDevice";

  public static final String A1 = "A1";

  public static final String U1 = "U1";
}
