package com.geotab.model.entity.device;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum DtcSeverity implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", -1),

  /**
   * This value indicates that the failure requests maintenance only.
   */
  MAINTENANCE_ONLY("MaintenanceOnly", 0),

  /**
   * This value indicates the failure that a check of the vehicle is required at next halt.
   */
  CHECK_AT_NEXT_HALT("CheckAtNextHalt", 1),

  /**
   * This value indicates the failure that an immediate check of the vehicle is required.
   */
  CHECK_IMMEDIATELY("CheckImmediately", 2);

  private final String name;
  private final int code;

  DtcSeverity(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
