/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.device;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum FaultState implements HasName {

  @JsonEnumDefaultValue
  NONE("None"),

  PENDING("Pending"),

  ACTIVE("Active"),

  CLEARED("Cleared"),

  INACTIVE("Inactive");

  private final String name;

  FaultState(String name) {
    this.name = name;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static FaultState findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          FaultState.class.getSimpleName(), FaultState.NONE);
      return NONE;
    }

    for (FaultState faultState : values()) {
      if (faultState.getName().equalsIgnoreCase(name.trim())) {
        return faultState;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, FaultState.class.getSimpleName(), FaultState.NONE);
    return NONE;
  }
}
