package com.geotab.model.entity.device;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.geotab.util.DeviceDefaultsUtil;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "go4v3Builder")
public class Go4v3 extends GoCurveAuxiliary implements RfChannelsAware {

  /**
   * Gets or sets the radio channels as an array of 20 bytes.
   *
   * <p>[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0].
   */
  protected short[] channel;

  /**
   * Gets or sets the channel count. Default [1].
   */
  protected Byte channelCount;

  /**
   * The FrequencyOffset used on the device radio. The default is 1 and should not be changed. Only has an effect on
   * Channel Set 0 - which consists of channels 0 to 15. Default [1].
   */
  protected Byte frequencyOffset;

  /**
   * Indicating whether this device has aided GPS enabled. This feature only applies to devices that use RF
   * communication in very large installations where an aiding data server has been configured. Default [false].
   */
  @JsonProperty("isAidedGpsEnabled")
  protected boolean isAidedGpsEnabled;

  /**
   * The toggle to enable RF upload while driving. Default [false].
   */
  @JsonProperty("isRfUploadOnWhenMoving")
  protected boolean isRfUploadOnWhenMoving;

  /**
   * The RF parameter version. Default [0].
   */
  protected short rfParameterVersion;

  {
    setDeviceType(DeviceType.GO4V3);
  }

  @Override
  public void populateDefaults() {
    super.populateDefaults();
    this.productId = GO4_V3_PRODUCT_ID;
    DeviceDefaultsUtil.addRfChannelDefaults(this);
  }

  public Go4v3 setChannel(short[] channel) {
    this.channel = checkAndPadChannelArray(channel);
    return this;
  }
}
