package com.geotab.model.entity.device;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The Geotab GO5 device. Additional properties can be seen in {@link GoCurve}.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "go5Builder")
public class Go5 extends GoCurve {

  {
    setDeviceType(DeviceType.GO5);
  }

  @Override
  public void populateDefaults() {
    super.populateDefaults();
    this.productId = GO5_PRODUCT_ID;
  }
}
