package com.geotab.model.entity.device;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The Geotab GO6 device. Additional properties can be seen in {@link GoCurveAuxiliary}.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "go6Builder")
public class Go6 extends GoCurveAuxiliary {

  {
    setDeviceType(DeviceType.GO6);
  }

  @Override
  public void populateDefaults() {
    super.populateDefaults();
    this.productId = GO6_PRODUCT_ID;
  }
}
