package com.geotab.model.entity.device;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The Geotab GO7 device. Additional properties can be seen in {@link GoCurveAuxiliary}.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "go7Builder")
public class Go7 extends GoCurveAuxiliary {

  {
    setDeviceType(DeviceType.GO7);
  }

  @Override
  public void populateDefaults() {
    super.populateDefaults();
    this.productId = GO7_PRODUCT_ID;
  }
}
