package com.geotab.model.entity.device;

import static java.lang.Boolean.FALSE;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The Geotab GO9B device. Additional properties can be seen in {@link GoCurveAuxiliary}.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "go9bBuilder")
public class Go9b extends GoCurveAuxiliary {

  /**
   * Enables or disables OBD alerts for the device. Default [False].
   */
  protected Boolean obdAlertEnabled;

  {
    setDeviceType(DeviceType.GO9B);
  }

  @Override
  public void populateDefaults() {
    super.populateDefaults();
    this.productId = GO9B_PRODUCT_ID;
    this.obdAlertEnabled = FALSE;
  }
}
