package com.geotab.model.entity.device;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A mobile tracking device that is used in MyGeotab. This is used for extensibility and is based on the {@link Device}
 * object.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "goDriveDeviceBuilder")
public class GoDriveDevice extends Device {

  {
    setDeviceType(DeviceType.GO_DRIVE_DEVICE);
  }
}
