/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.device;

import com.geotab.model.Id;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

/**
 * A {@link Device} type that represents no device.
 */
@Data
public final class NoDevice extends Device implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final NoDevice INSTANCE = new NoDevice();
  }

  public static final String NO_DEVICE_ID = "NoDeviceId";

  private NoDevice() {
    setId(new Id(NO_DEVICE_ID));
    setName("**NoDevice");
    setVersion(0L);
  }

  public static NoDevice getInstance() {
    return InstanceHolder.INSTANCE;
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
