package com.geotab.model.entity.deviceconnectionstatus;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum DeviceConnectionStatus {
  /**
   * The device is currently connected and active.
   */
  Active(0),
  /**
   * The connection is inactive and was terminated normally.
   */
  Disconnected(1),
  /**
   * The device is currently connected but not active.
   */
  Inactive(4);

  private final int value;

  DeviceConnectionStatus(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }
}
