/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.diagnostic;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A {@link Diagnostic} that represents measurement data from the vehicle (as opposed to fault codes).
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "dataDiagnosticBuilder")
public class DataDiagnostic extends Diagnostic {

  private Double conversion;
  private Integer dataLength;
  private Double offset;

  {
    setDiagnosticType(DiagnosticType.DATA_DIAGNOSTIC);
  }
}
