package com.geotab.model.entity.diagnostic;
/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum ValidLoggingPeriod implements HasName {

  /**
   * No period in which it is valid to interpolate.
   */
  @JsonEnumDefaultValue
  NONE("None", 0),

  /**
   * May be logged within the active state of the device.
   */
  ACTIVE("Active", 1),

  /**
   * May be logged within the power state of the device.
   */
  POWER("Power", 2);

  private final String name;
  private final int code;

  ValidLoggingPeriod(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static ValidLoggingPeriod findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          ValidLoggingPeriod.class.getSimpleName(), NONE);
      return NONE;
    }

    for (ValidLoggingPeriod validLoggingPeriod : values()) {
      if (validLoggingPeriod.getName().equalsIgnoreCase(name.trim())) {
        return validLoggingPeriod;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, ValidLoggingPeriod.class.getSimpleName(), NONE);
    return NONE;
  }
}
