/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.distributionlist;

import static com.fasterxml.jackson.annotation.JsonTypeInfo.As.EXISTING_PROPERTY;
import static com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NAME;
import static com.geotab.model.entity.distributionlist.ImportExportDistributionList.IMPORT_EXPORT_DISTRIBUTION_LIST_ID;
import static com.geotab.model.entity.distributionlist.NewsDistributionList.NEWS_DISTRIBUTION_LIST_ID;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonSubTypes.Type;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.geotab.model.entity.NameEntity;
import com.geotab.model.entity.recipient.Recipient;
import com.geotab.model.entity.recipient.RecipientType;
import com.geotab.model.entity.rule.Rule;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A distribution list links a set of {@link Rule}(s) to a set of {@link Recipient}(s). When a {@link  Rule} is violated
 * each related {@link Recipient} will receive a notification of the kind defined by its  {@link  RecipientType}.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "distributionListBuilder")
@JsonTypeInfo(use = NAME, include = EXISTING_PROPERTY, property = "id", visible = true,
    defaultImpl = DistributionList.class)
@JsonSubTypes({
    @Type(value = ImportExportDistributionList.class, name = IMPORT_EXPORT_DISTRIBUTION_LIST_ID),
    @Type(value = NewsDistributionList.class, name = NEWS_DISTRIBUTION_LIST_ID)
})
public class DistributionList extends NameEntity {

  /**
   * The list of recipients that will be notified when the {@link Rule}(s) are violated.
   */
  private List<Recipient> recipients;

  /**
   * The list of {@link Rule}(s) that the {@link Recipient}(s) will be notified of when broken.
   */
  private List<Rule> rules;
}
