/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.distributionlist;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonProperty.Access;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The base class for {@link DistributionList}(s) that are system entities.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public abstract class DistributionListSystem extends DistributionList {

  @JsonProperty(access = Access.WRITE_ONLY)
  public String getName() {
    return super.getName();
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
