/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.distributionlist;

import com.geotab.model.Id;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Distribution lists for Import/Export notifications.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "importExportDistributionListBuilder")
public class ImportExportDistributionList extends DistributionListSystem {

  public static final String IMPORT_EXPORT_DISTRIBUTION_LIST_ID = "DistributionListImportExportId";
  public static final String IMPORT_EXPORT_DISTRIBUTION_LIST_NAME = "**Import/Export";

  {
    setId(new Id(IMPORT_EXPORT_DISTRIBUTION_LIST_ID));
    setName(IMPORT_EXPORT_DISTRIBUTION_LIST_NAME);
  }
}
