/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.dutystatus;

import java.time.Duration;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The duration of time remaining for a specific {@link DutyStatusViolationType}.
 */
@Data
@NoArgsConstructor
public class DutyStatusAvailabilityDuration {

  /**
   * The duration of the specific {@link DutyStatusViolationType}.
   */
  private Duration duration;

  /**
   * The specific {@link DutyStatusViolationType}.
   */
  private DutyStatusViolationType type;

  @Builder
  public DutyStatusAvailabilityDuration(Duration duration, DutyStatusViolationType type) {
    this.duration = duration;
    this.type = type;
  }
}
