/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.dutystatus;

import java.time.Duration;
import java.time.LocalDateTime;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Represents total cycle hours that will be available in the up coming days.
 */
@Data
@NoArgsConstructor
public class DutyStatusCycleAvailability {

  /**
   * The amount of cycle time available.
   */
  private Duration available;

  /**
   * The cycle gain date.
   */
  private LocalDateTime dateTime;

  @Builder
  public DutyStatusCycleAvailability(Duration available, LocalDateTime dateTime) {
    this.available = available;
    this.dateTime = dateTime;
  }
}
