/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.dutystatus;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum DutyStatusDeferralType implements HasName {

  /**
   * No deferral applied.
   */
  @JsonEnumDefaultValue
  NONE("None", 0),

  /**
   * Day one of deferral.
   */
  DAY_ONE("DayOne", 1),

  /**
   * Day two of deferral.
   */
  DAY_TWO("DayTwo", 2);

  private final String name;
  private final int code;

  DutyStatusDeferralType(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static DutyStatusDeferralType findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          DutyStatusDeferralType.class.getSimpleName(), DutyStatusDeferralType.NONE);
      return NONE;
    }

    for (DutyStatusDeferralType dutyStatusDeferralType : values()) {
      if (dutyStatusDeferralType.getName().equalsIgnoreCase(name.trim())) {
        return dutyStatusDeferralType;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, DutyStatusDeferralType.class.getSimpleName(), DutyStatusDeferralType.NONE);
    return NONE;
  }
}
