/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.dutystatus;

import java.time.Duration;
import java.time.LocalDateTime;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Represents a single days total hours that count towards the cycle limit.
 */
@Data
@NoArgsConstructor
public class DutyStatusRecap {

  /**
   * The duration of time counting towards cycle.
   */
  private Duration duration;

  /**
   * The date and time of the recap.
   */
  private LocalDateTime dateTime;

  @Builder
  public DutyStatusRecap(Duration duration, LocalDateTime dateTime) {
    this.duration = duration;
    this.dateTime = dateTime;
  }
}
