/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.dutystatus;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.Id;
import com.geotab.model.entity.Entity;
import com.geotab.model.entity.user.User;
import com.geotab.model.serialization.EntityAsIdSerializer;
import com.geotab.model.serialization.IdAsStringSerializer;
import java.time.Duration;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A {@link DutyStatusViolation} for a {@link User}.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class DutyStatusViolation extends Entity {

  /**
   * The driving duration of the duty status violation.
   */
  private Duration drivingDuration;

  /**
   * The {@link User} associated with the duty status violation.
   */
  @JsonSerialize(using = EntityAsIdSerializer.class)
  private User driver;

  /**
   * The date and time that the duty status violation started.
   */
  private LocalDateTime fromDate;

  /**
   * The date and time that the duty status violation ended.
   */
  private LocalDateTime toDate;

  /**
   * The stated reason why the duty status violation occurred. *Deprecated. Will be removed in a future version. The
   * data in the 'Reason' property string is now provided as 'DaysLimit' and 'HoursLimit' for better programmatic
   * access.
   */
  private String reason;

  /**
   * The {@link DutyStatusViolationType} of the duty status violation.
   */
  private DutyStatusViolationType type;

  /**
   * The maximum or minimum hours limit of the duty status violation.
   */
  private Integer hoursLimit;

  /**
   * The maximum or minimum days limit of the duty status violation.
   */
  private Integer daysLimit;

  /**
   * The log Id.
   */
  @JsonSerialize(using = IdAsStringSerializer.class)
  private Id logId;

  @Override
  public DutyStatusViolation setId(Id id) {
    throw new UnsupportedOperationException();
  }

  @Override
  public Id getId() {
    return null;
  }
}
