/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.dutystatus;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum DutyStatusViolationType implements HasName {

  /**
   * None.
   */
  @JsonEnumDefaultValue
  NONE("None"),

  /**
   * Driving limits.
   */
  DRIVING("Driving"),

  /**
   * Rest requirements.
   */
  REST("Rest"),

  /**
   * On-duty limits.
   */
  DUTY("Duty"),

  /**
   * Work day limits.
   */
  WORKDAY("Workday"),

  /**
   * Cycle limits.
   */
  CYCLE("Cycle"),

  /**
   * Daily driving limits.
   */
  DAILY_DRIVING("DailyDriving"),

  /**
   * Daily rest requirements.
   */
  DAILY_REST("DailyRest"),

  /**
   * Daily duty limits.
   */
  DAILY_DUTY("DailyDuty"),

  /**
   * Daily off-duty requirements.
   */
  DAILY_OFF("DailyOff"),

  /**
   * Cycle rest requirements.
   */
  CYCLE_REST("CycleRest"),

  /**
   * On-duty since cycle rest limit.
   */
  DUTY_SINCE_CYCLE_REST("DutySinceCycleRest"),

  EWD_REST("EwdRest"),

  EWD_WORK("EwdWork"),

  EWD_WORK_EXEMPTION("EwdWorkExemption");

  private final String name;

  DutyStatusViolationType(String name) {
    this.name = name;
  }


  @JsonValue
  public String getName() {
    return name;
  }

  public static DutyStatusViolationType findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          DutyStatusViolationType.class.getSimpleName(), DutyStatusViolationType.NONE);
      return NONE;
    }

    DutyStatusViolationType dutyStatusViolationType = findByName(name);
    if (dutyStatusViolationType != null) {
      return dutyStatusViolationType;
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, DutyStatusViolationType.class.getSimpleName(), DutyStatusViolationType.NONE);
    return NONE;
  }

  public static DutyStatusViolationType findByName(String name) {
    if (Util.isEmpty(name)) {
      return null;
    }

    for (DutyStatusViolationType dutyStatusViolationType : values()) {
      if (dutyStatusViolationType.getName().equalsIgnoreCase(name.trim())) {
        return dutyStatusViolationType;
      }
    }

    return null;
  }
}

