/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.dvirlog;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.entity.Entity;
import com.geotab.model.entity.file.MediaFile;
import com.geotab.model.entity.user.User;
import com.geotab.model.serialization.EntityAsIdSerializer;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A DefectRemark is a remark that can be associated with a {@link DVIRDefect}.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class DefectRemark extends Entity {

  /**
   * The {@link DVIRDefect} which this DefectRemark belongs to.
   */
  @JsonProperty("dVIRDefect")
  @SuppressWarnings({"AbbreviationAsWordInName"})
  private DVIRDefect dVIRDefect;

  /**
   * The DVIR text associated with the log.
   */
  private String remark;

  /**
   * The {@link User} who created the log.
   */
  @JsonSerialize(using = EntityAsIdSerializer.class)
  private User user;

  /**
   * The date and time the log was created.
   */
  private LocalDateTime dateTime;

  /**
   * The list of {@link MediaFile} for a defect remark.
   */
  private List<MediaFile> mediaFiles;
}
