package com.geotab.model.entity.entitysettings;

import com.geotab.model.Id;
import com.geotab.model.entity.Entity;
import com.geotab.model.entity.addins.AddInData;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * <isSupported>false</isSupported>
 * Represents a entity-linked setting in JSON format. Every setting has an specific key.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class EntitySetting extends Entity {
  /**
   * Gets or sets the key for this setting.
   */
  private String key;

  /**
   * Gets or sets the {@link EntityType} of this setting.
   */
  private EntityType entityType;

  /**
   * Gets or sets the entity identifier of this setting.
   */
  private Id entityId;

  /**
   * Gets or sets the setting value of this setting as a JSON string.
   */
  private String settingValue;

  /**
   * Gets or sets the {@link AddInData} for this setting.
   */
  private AddInData data;

  @Override
  public String toString() {
    return "Id: {" + this.getId() + "}, Key: {" + this.key + "}, EntityType: {" + entityType.toString() + "}, EntityId: {" + entityId + "}";
  }
}
