package com.geotab.model.entity.entitysettings;

import lombok.Getter;

/**
 * Extension of legal files: 0 refers to 'tgd', 1 refers to 'ddd', and 2 refers to 'V1b'.
 */
@Getter
public enum TachographFileFormat {
  /**
   * Spanish file format TGD.
   */
  Tgd(0),
  /**
   * Standard file format DDD.
   */
  Ddd(1),

  /**
   * French file format V1B.
   */
  V1b(2);

  private final int value;

  TachographFileFormat(int value) {
    this.value = value;
  }

}
