/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.exceptionevent;

import com.geotab.model.Id;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

/**
 * An Exception Event which represents no value.
 */
@Data
public class NoExceptionEvent extends ExceptionEvent implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final NoExceptionEvent INSTANCE = new NoExceptionEvent();
  }

  public static final String NO_EXCEPTION_EVENT_ID = "NoExceptionEventId";

  private NoExceptionEvent() {
    setId(new Id(NO_EXCEPTION_EVENT_ID));
    setVersion(0L);
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }

  public static NoExceptionEvent getInstance() {
    return NoExceptionEvent.InstanceHolder.INSTANCE;
  }
}
