/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.exceptionevent.state;

import com.geotab.model.entity.NameEntity;
import com.geotab.model.entity.exceptionevent.ExceptionEvent;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import com.geotab.util.Util;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Specify the current state of the {@link ExceptionEvent}.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class ExceptionEventState extends NameEntity implements SystemEntitySerializationAware {

  /**
   * The key of this entity that uniquely identifies it.
   */
  private Short key;

  @Override
  public boolean isSystemEntity() {
    return true;
  }

  public static ExceptionEventState fromSystem(String id) {
    if (Util.isEmpty(id)) return null;
    switch (id) {
      case ExceptionEventStateInvalid.EXCEPTION_EVENT_STATE_INVALID_ID:
        return ExceptionEventStateInvalid.getInstance();
      case ExceptionEventStateValid.EXCEPTION_EVENT_STATE_VALID_ID:
        return ExceptionEventStateValid.getInstance();
      default:
        return null;
    }
  }
}
