/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.exceptionevent.state;

import com.geotab.model.Id;
import com.geotab.model.entity.exceptionevent.ExceptionEvent;
import lombok.Data;

/**
 * Specifies that the {@link ExceptionEvent} is invalid.
 */
@Data
public class ExceptionEventStateInvalid extends ExceptionEventState {

  private static class InstanceHolder {

    private static final ExceptionEventStateInvalid INSTANCE = new ExceptionEventStateInvalid();
  }

  public static final String EXCEPTION_EVENT_STATE_INVALID_ID = "ExceptionEventStateInvalidId";

  private ExceptionEventStateInvalid() {
    setId(new Id(EXCEPTION_EVENT_STATE_INVALID_ID));
    setName("Invalid");
    setKey((short) 1);
  }

  public static ExceptionEventStateInvalid getInstance() {
    return ExceptionEventStateInvalid.InstanceHolder.INSTANCE;
  }
}
