/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.exceptionevent.state;

import com.geotab.model.Id;
import com.geotab.model.entity.exceptionevent.ExceptionEvent;
import lombok.Data;

/**
 * Specifies that the {@link ExceptionEvent} is valid.
 */
@Data
public class ExceptionEventStateValid extends ExceptionEventState {

  private static class InstanceHolder {

    private static final ExceptionEventStateValid INSTANCE = new ExceptionEventStateValid();
  }

  public static final String EXCEPTION_EVENT_STATE_VALID_ID = "ExceptionEventStateValidId";

  private ExceptionEventStateValid() {
    setId(new Id(EXCEPTION_EVENT_STATE_VALID_ID));
    setName("Valid");
    setKey((short) 0);
  }

  public static ExceptionEventStateValid getInstance() {
    return ExceptionEventStateValid.InstanceHolder.INSTANCE;
  }
}
