/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.faultdata;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum FaultLampState implements HasName {

  /**
   * Fault lamp is off, no active fault state.
   */
  @JsonEnumDefaultValue
  NONE("None"),

  /**
   * Malfunction lamp is active.
   */
  MALFUNCTION("Malfunction"),

  /**
   * Amber warning lamp is active.
   */
  WARNING("Warning"),

  /**
   * Red stop lamp is active.
   */
  STOP("Stop"),

  /**
   * Protect lamp is active.
   */
  PROTECT("Protect");

  private final String name;

  FaultLampState(String name) {
    this.name = name;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static FaultLampState findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          FaultLampState.class.getSimpleName(), FaultLampState.NONE);
      return NONE;
    }

    for (FaultLampState faultLampState : values()) {
      if (faultLampState.getName().equalsIgnoreCase(name.trim())) {
        return faultLampState;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, FaultLampState.class.getSimpleName(), FaultLampState.NONE);
    return NONE;
  }
}
