/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.faultdata;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum FaultResetMode implements HasName {

  /**
   * The engine FaultData ExceptionEvent for this kind of Diagnostic can contain a number of sequential {@link
   * FaultData} instances. These instances will continue to grow until the fault condition ends.
   */
  @JsonEnumDefaultValue
  NONE("None", 0),

  /**
   * The engine FaultData ExceptionEvent for this kind of Diagnostic will always contain single FaultData instance.
   */
  AUTO_RESET("AutoReset", 1);

  private final String name;
  private final int code;

  FaultResetMode(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static FaultResetMode findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          FaultResetMode.class.getSimpleName(), FaultResetMode.NONE);
      return NONE;
    }

    for (FaultResetMode faultResetMode : values()) {
      if (faultResetMode.getName().equalsIgnoreCase(name.trim())) {
        return faultResetMode;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, FaultResetMode.class.getSimpleName(), FaultResetMode.NONE);
    return NONE;
  }
}
