package com.geotab.model.entity.faultdata;

import com.geotab.model.Id;
import lombok.Data;

/**
 * The Active Fault Status.
 */
@Data
public final class FaultStatusActive extends FaultStatus {

  private static class InstanceHolder {

    private static final FaultStatusActive INSTANCE = new FaultStatusActive();
  }

  public static final String FAULT_STATUS_ACTIVE_ID = "FaultStatusActiveId";
  public static final String FAULT_STATUS_ACTIVE_NAME = "Active";

  public static FaultStatusActive getInstance() {
    return FaultStatusActive.InstanceHolder.INSTANCE;
  }

  private FaultStatusActive() {
    setId(new Id(FAULT_STATUS_ACTIVE_ID));
    setName(FAULT_STATUS_ACTIVE_NAME);
  }
}
