package com.geotab.model.entity.faultdata;

import com.geotab.model.Id;
import lombok.Data;

/**
 * The Cleared Fault Status.
 */
@Data
public final class FaultStatusCleared extends FaultStatus {

  private static class InstanceHolder {

    private static final FaultStatusCleared INSTANCE = new FaultStatusCleared();
  }

  public static final String FAULT_STATUS_CLEARED_ID = "FaultStatusClearedId";
  public static final String FAULT_STATUS_CLEARED_NAME = "Cleared";

  public static FaultStatusCleared getInstance() {
    return FaultStatusCleared.InstanceHolder.INSTANCE;
  }

  private FaultStatusCleared() {
    setId(new Id(FAULT_STATUS_CLEARED_ID));
    setName(FAULT_STATUS_CLEARED_NAME);
  }
}
