package com.geotab.model.entity.faultdata;

import com.geotab.model.Id;
import lombok.Data;

/**
 * The Inactive Fault Status.
 */
@Data
public final class FaultStatusInactive extends FaultStatus {

  private static class InstanceHolder {

    private static final FaultStatusInactive INSTANCE = new FaultStatusInactive();
  }

  public static final String FAULT_STATUS_INACTIVE_ID = "FaultStatusInactiveId";
  public static final String FAULT_STATUS_INACTIVE_NAME = "Inactive";

  public static FaultStatusInactive getInstance() {
    return FaultStatusInactive.InstanceHolder.INSTANCE;
  }

  private FaultStatusInactive() {
    setId(new Id(FAULT_STATUS_INACTIVE_ID));
    setName(FAULT_STATUS_INACTIVE_NAME);
  }
}
