package com.geotab.model.entity.faultdata;

import com.geotab.model.Id;
import lombok.Data;

/**
 * The Pending Fault Status.
 */
@Data
public final class FaultStatusPending extends FaultStatus {

  private static class InstanceHolder {

    private static final FaultStatusPending INSTANCE = new FaultStatusPending();
  }

  public static final String FAULT_STATUS_PENDING_ID = "FaultStatusPendingId";
  public static final String FAULT_STATUS_PENDING_NAME = "Pending";

  public static FaultStatusPending getInstance() {
    return FaultStatusPending.InstanceHolder.INSTANCE;
  }

  private FaultStatusPending() {
    setId(new Id(FAULT_STATUS_PENDING_ID));
    setName(FAULT_STATUS_PENDING_NAME);
  }
}
