/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.file;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.Id;
import com.geotab.model.entity.NameEntityWithVersion;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.user.Driver;
import com.geotab.model.serialization.DriverEmbeddedSerializer;
import com.geotab.model.serialization.DriverFromIdDeserializer;
import com.geotab.model.serialization.IdAsStringSerializer;
import com.geotab.model.serialization.JsonAsStringDeserializer;
import com.geotab.model.serialization.StringAsRawJsonSerializer;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A named tag to provide context to an entity.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class MediaFile extends NameEntityWithVersion {

  /**
   * The {@link MediaType}.
   */
  private MediaType mediaType;

  /**
   * The list of tags to provide context to the file.
   */
  private List<Tag> tags;

  /**
   * The {@link Driver} associated with the file.
   */
  @JsonDeserialize(using = DriverFromIdDeserializer.class)
  @JsonSerialize(using = DriverEmbeddedSerializer.class)
  private Driver driver;

  /**
   * The {@link Device} associated with the file.
   */
  private Device device;

  /**
   * The from date.
   */
  private LocalDateTime fromDate;

  /**
   * The to date.
   */
  private LocalDateTime toDate;

  /**
   * The list of files which serve as the thumbnail for this file.
   */
  private List<MediaFile> thumbnails;

  /**
   * The file processing {@link Status}.
   */
  private Status status;

  /**
   * File metadata in JSON format.
   */
  @JsonDeserialize(using = JsonAsStringDeserializer.class)
  @JsonSerialize(using = StringAsRawJsonSerializer.class)
  private String metaData;

  /**
   * The {@link Id} of the solution which added the data.
   */
  @JsonSerialize(using = IdAsStringSerializer.class)
  private Id solutionId;
}
