/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.flashcode;

import com.geotab.model.entity.NameEntity;
import com.geotab.model.entity.diagnostic.Diagnostic;
import com.geotab.model.entity.failuremode.FailureMode;
import com.geotab.model.entity.faultdata.FaultData;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The optional summary code references for specific {@link Diagnostic} items referencing {@link FaultData} records.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class FlashCode extends NameEntity {

  /**
   * The circuit index reference to the flash code.
   */
  private String circuitIndex;

  /**
   * The associated {@link Diagnostic} to the flash code.
   */
  private Diagnostic diagnostic;

  /**
   * The associated {@link FailureMode} to the flash code.
   */
  private FailureMode failureMode;

  /**
   * The flash code index.
   */
  private String flashCodeIndex;

  /**
   * An optional URL which points to the associated documentation for the flash code.
   */
  private String helpUrl;

  /**
   * The page reference, if applicable.
   */
  private String pageReference;

  /**
   * The priority level of the fault flash code.
   */
  private Integer priorityLevel;
}
