/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.fuel;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.user.Driver;
import com.geotab.model.serialization.DriverEmbeddedSerializer;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Log of fueling events.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "fuelTransactionBuilder")
public class FuelTransaction extends FuelEvent {

  /**
   * The {@link Device} the transaction belongs to. Default [null].
   *
   * <p>If null, best attempt will be auto matched to a device based on
   * vehicleIdentificationNumber, serialNumber, licencePlate or comments properties.
   */
  private Device device;

  /**
   * The driver the transaction belongs to.
   *
   * <p>If null, best attempt will be auto matched to a driver based on driverName property.
   */
  @JsonSerialize(using = DriverEmbeddedSerializer.class)
  private Driver driver;

  /**
   * The vehicle identification number (VIN) of the vehicle. This is used to associate the transaction with a {@link
   * Device}. Maximum length [255] Default [""].
   */
  private String vehicleIdentificationNumber;

  /**
   * the vehicle description of the vehicle. This can be used to associate the transaction with a {@link Device}.
   * Maximum length [255] Default [""].
   */
  private String description;

  /**
   * The licence plate of the vehicle of the vehicle. This can be used to associate the transaction with a {@link
   * Device}. Maximum length [255] Default [""].
   */
  private String licencePlate;

  /**
   * The free text field where any user information can be stored and referenced for this entity. This can be used to
   * associate the transaction with a {@link Device}. Maximum length [1024] Default [""].
   */
  private String comments;

  /**
   * The serial number of the device. This can be used to associate the transaction with a {@link Device}. Maximum
   * length [255] Default [""].
   */
  private String serialNumber;

  /**
   * The {@link FuelTransactionProvider} of this transaction. Default [Unknown].
   */
  private FuelTransactionProvider provider;

  /**
   * The fuel card holder name. This can be used to associate the transaction with a {@link Device}. Maximum length
   * [255] Default [""].
   */
  private String driverName;

  /**
   * The JSON string representing the source data. Default [""].
   */
  private String sourceData;

  /**
   * The external reference to the transaction. Typically this is an external identifier. Maximum length [255] Default
   * [""].
   */
  private String externalReference;

  /**
   * The masked or partial purchasing card number.
   */
  private String cardNumber;

  /**
   * The site/merchant name where the transaction took place.
   */
  private String siteName;

  /**
   * The Product Description given by the Provider.
   */
  private String providerProductDescription;
}
