package com.geotab.model.entity.group;

import com.geotab.model.Id;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * This is a system {@link Group} with an Id of GroupCompanyId and is the root group of the organization structure. The
 * entire sub tree of this group is user defined.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "companyGroupBuilder")
public class CompanyGroup extends SystemGroupBase {

  public static final String COMPANY_GROUP_ID = "GroupCompanyId";
  public static final String COMPANY_GROUP_NAME = "**Org**";

  {
    setId(new Id(COMPANY_GROUP_ID));
    setName(COMPANY_GROUP_NAME);
  }
}
