package com.geotab.model.entity.group;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum DefectSeverity implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", -1),

  /**
   * Severity level for Unregulated Defects (vehicle or trailer is safe to operate).
   */
  UNREGULATED("Unregulated", -1),

  /**
   * Normal defect severity.
   */
  NORMAL("Normal", 0),

  /**
   * Critical defect severity (vehicle or trailer is unsafe to operate).
   */
  CRITICAL("Critical", 1);

  private final String name;
  private final int code;

  DefectSeverity(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }


  public static DefectSeverity findOrDefault(String value) {
    if (value == null) {
      return null;
    }
    switch (value) {
      case "Critical":
        return CRITICAL;
      case "Unregulated":
        return UNREGULATED;
      default:
        return NORMAL;
    }
  }
}
