package com.geotab.model.entity.group;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.geotab.model.Id;
import com.geotab.model.serialization.DefectListDeserializer;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * This is a {@link Defect} with an Id of GroupDefectsId. This is the root defect group for vehicle and trailer defects.
 * The children of this group are not user defined.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "defectsGroupBuilder")
public class DefectsGroup extends Defect {

  public static final String DEFECTS_GROUP_ID = "GroupDefectsId";
  public static final String DEFECTS_GROUP_NAME = "**Defects**";

  {
    setId(new Id(DEFECTS_GROUP_ID));
    setName(DEFECTS_GROUP_NAME);
  }

  @Override
  @JsonDeserialize(using = DefectListDeserializer.class)
  public List<Group> getChildren() {
    return super.getChildren();
  }
}
