package com.geotab.model.entity.group;

import com.geotab.model.Id;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * This is a {@link SystemSecurityClearance} with an Id of GroupDriveUserSecurityId. A user that has this group assigned
 * to its security groups will have access to all features of the Geotab Drive app.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "driveUserSecurityGroupBuilder")
public class DriveUserSecurityGroup extends SystemSecurityClearance {

  public static final String DRIVE_USER_SECURITY_GROUP_ID = "GroupDriveUserSecurityId";
  public static final String DRIVE_USER_SECURITY_GROUP_NAME = "**DriveUserSecurity**";

  {
    setId(new Id(DRIVE_USER_SECURITY_GROUP_ID));
    setName(DRIVE_USER_SECURITY_GROUP_NAME);
  }
}
