package com.geotab.model.entity.group;

import com.geotab.model.Id;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * This is a {@link SystemSecurityClearance} with an Id of GroupEverythingSecurityId. User(s) that have this group
 * assigned to their security groups means they have access to everything in the system.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "everythingSecurityGroupBuilder")
public class EverythingSecurityGroup extends SystemSecurityClearance {

  public static final String EVERYTHING_SECURITY_GROUP_ID = "GroupEverythingSecurityId";
  public static final String EVERYTHING_SECURITY_GROUP_NAME = "**EverythingSecurity**";

  {
    setId(new Id(EVERYTHING_SECURITY_GROUP_ID));
    setName(EVERYTHING_SECURITY_GROUP_NAME);
  }
}
