package com.geotab.model.entity.group;

import com.geotab.model.Id;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * This is a {@link SystemSecurityClearance} with an Id of GroupSupervisorSecurityId. A user that has this group in its
 * security groups will have access to modify local data in the system. This is the type of user that does not need to
 * administrate the system, but needs to create devices, zones, work times etc.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "supervisorSecurityGroupBuilder")
public class SupervisorSecurityGroup extends SystemSecurityClearance {

  public static final String SUPERVISOR_SECURITY_GROUP_ID = "GroupSupervisorSecurityId";
  public static final String SUPERVISOR_SECURITY_GROUP_NAME = "**SupervisorSecurity**";

  {
    setId(new Id(SUPERVISOR_SECURITY_GROUP_ID));
    setName(SUPERVISOR_SECURITY_GROUP_NAME);
  }
}
